package gov.va.med.mhv.getcare.common.dto;

import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonIgnore;

import gov.va.med.mhv.getcare.util.CommonUtility;

public class AppointmentDTO implements Serializable{

	private static final long serialVersionUID = -1788159972444874365L;
	
	
	private Long appointmentID;
	private String currentStatus;
	private String clinicName;
	private String appointmentStatus;
	private String clinicPhone;
	private String appointmentType;
	private Date xrayDatePrecise;
	private String xrayDateImprecise;
	private Date labDatePrecise;
	private String labDateImprecise;
	private Date apptDatePrecise;
	private String apptDateImprecise;  
	private Date ekgDatePrecise;
	private String ekgDateImprecise;         
	private String ien;         
	private Long patientId;       
	private Long facilityInfoId; 
	private Long phrFacilityControlId;    
	private String location;
	public Long getAppointmentID() {
		return appointmentID;
	}
	public void setAppointmentID(Long appointmentID) {
		this.appointmentID = appointmentID;
	}
	public String getCurrentStatus() {
		return currentStatus;
	}
	public void setCurrentStatus(String currentStatus) {
		this.currentStatus = currentStatus;
	}
	public String getClinicName() {
		return clinicName;
	}
	public void setClinicName(String clinicName) {
		this.clinicName = clinicName;
	}
	public String getAppointmentStatus() {
		return appointmentStatus;
	}
	public void setAppointmentStatus(String appointmentStatus) {
		this.appointmentStatus = appointmentStatus;
	}
	public String getClinicPhone() {
		return clinicPhone;
	}
	public void setClinicPhone(String clinicPhone) {
		this.clinicPhone = clinicPhone;
	}
	public String getAppointmentType() {
		return appointmentType;
	}
	public void setAppointmentType(String appointmentType) {
		this.appointmentType = appointmentType;
	}
	public Date getXrayDatePrecise() {
		return xrayDatePrecise;
	}
	public void setXrayDatePrecise(Date xrayDatePrecise) {
		this.xrayDatePrecise = xrayDatePrecise;
	}
	public String getXrayDateImprecise() {
		return xrayDateImprecise;
	}
	public void setXrayDateImprecise(String xrayDateImprecise) {
		this.xrayDateImprecise = xrayDateImprecise;
	}
	public Date getLabDatePrecise() {
		return labDatePrecise;
	}
	public void setLabDatePrecise(Date labDatePrecise) {
		this.labDatePrecise = labDatePrecise;
	}
	public String getLabDateImprecise() {
		return labDateImprecise;
	}
	public void setLabDateImprecise(String labDateImprecise) {
		this.labDateImprecise = labDateImprecise;
	}
	public Date getApptDatePrecise() {
		return apptDatePrecise;
	}
	public void setApptDatePrecise(Date apptDatePrecise) {
		this.apptDatePrecise = apptDatePrecise;
	}
	public String getApptDateImprecise() {
		return apptDateImprecise;
	}
	public void setApptDateImprecise(String apptDateImprecise) {
		this.apptDateImprecise = apptDateImprecise;
	}
	public Date getEkgDatePrecise() {
		return ekgDatePrecise;
	}
	public void setEkgDatePrecise(Date ekgDatePrecise) {
		this.ekgDatePrecise = ekgDatePrecise;
	}
	public String getEkgDateImprecise() {
		return ekgDateImprecise;
	}
	public void setEkgDateImprecise(String ekgDateImprecise) {
		this.ekgDateImprecise = ekgDateImprecise;
	}
	public String getIen() {
		return ien;
	}
	public void setIen(String ien) {
		this.ien = ien;
	}
	public Long getPatientId() {
		return patientId;
	}
	public void setPatientId(Long patientId) {
		this.patientId = patientId;
	}
	public Long getFacilityInfoId() {
		return facilityInfoId;
	}
	public void setFacilityInfoId(Long facilityInfoId) {
		this.facilityInfoId = facilityInfoId;
	}
	public Long getPhrFacilityControlId() {
		return phrFacilityControlId;
	}
	public void setPhrFacilityControlId(Long phrFacilityControlId) {
		this.phrFacilityControlId = phrFacilityControlId;
	}
	public String getLocation() {
		return location;
	}
	public void setLocation(String location) {
		this.location = location;
	}
	
	@JsonIgnore
	public String getDisplayAppointmentDate() {
		return  CommonUtility.dateToString(getApptDatePrecise(), "MM/dd/yyyy HH:mm");
	}
	
	@JsonIgnore
	public String getDisplayStatus() {
		String aptStatus=null;
		String tempString=null; 
		if(getAppointmentStatus()  != null){
			if(getAppointmentStatus().equals("N")){
				aptStatus="APPOINTMENT NOT KEPT";
			}else if(getAppointmentStatus().equals("NA")){
				aptStatus="APPOINTMENT NOT KEPT";
			}else if(getAppointmentStatus().equals("C")){
				aptStatus="CANCELLED";
			}else if(getAppointmentStatus().equals("CA")){
				aptStatus="CANCELLED";
			}else if(getAppointmentStatus().equals("I")){
				aptStatus="INPATIENT APPOINTMENT";
			}else if(getAppointmentStatus().equals("PC")){
				aptStatus="CANCELLED";
			}else if(getAppointmentStatus().equals("PCA")){
				aptStatus="CANCELLED";
			}else if(getAppointmentStatus().equals("NT")){
				aptStatus="NOT APPLICABLE";
			}else {
			   aptStatus="UNKNOWN";
			}
		}
		if(aptStatus == null ){
			tempString = "APPOINTMENT KEPT";
			
			if(getCurrentStatus() == null){
				if(!getApptDatePrecise().after(new Date())){
					tempString="--";
				}
			}else{
				if(getCurrentStatus().equals("NO ACTION TAKEN")){
				   tempString ="NOT APPLICABLE";
				}
				if(getCurrentStatus().equals("NO ACTION TAKEN/TODAY")){
					   tempString ="NOT APPLICABLE";
				}
				if(getCurrentStatus().equals("CHECKED IN")){
					   tempString ="APPOINTMENT KEPT";
				}
				if(getCurrentStatus().equals("CHECKED OUT")){
					   tempString ="APPOINTMENT KEPT";
				}
				if(getCurrentStatus().equals("NON-COUNT")){
					if(getApptDatePrecise().after(new Date())){
						   tempString = "FUTURE";
						}else{
							tempString = "UPDATE IN PROGRESS";
						}
				}
				if(getCurrentStatus().equals("NON-COUNT/CHECKED-OUT")){
					   tempString ="APPOINTMENT KEPT";
				}
				if(getCurrentStatus().equals("NON-COUNT/CHECKED-IN")){
					   tempString ="APPOINTMENT KEPT";
				}
				if(getCurrentStatus().equals("FUTURE")){
					if(getApptDatePrecise().after(new Date())){
					   tempString ="FUTURE";
					}else{
						tempString ="UPDATE IN PROGRESS";
					}
				}
				
	    	}
       }
	   if(aptStatus != null){
		   tempString=aptStatus;
		   if(aptStatus.equals("INPATIENT APPOINTMENT")){
			   if(getCurrentStatus() == null){
				   tempString="--";
			   }else{
				   if(getCurrentStatus().equals("INPATIENT/NO ACT TAKN")){
					   tempString="NOT APPLICABLE";
				   }
				   if(getCurrentStatus().equals("INPATIENT/FUTURE")){
					   tempString="FUTURE";
				   }
				   if(getCurrentStatus().equals("INPATIENT/ACT REQ")){
					   tempString="NOT APPLICABLE";
				   }
			   }
		   }
	   }
	   return tempString;	
	}
}
